<?php
defined('BASEPATH') OR exit('No direct script access allowed');

function tgl_convert($date)
{  
  $bulan = array (
    1 =>   'Januari',
    'Februari',
    'Maret',
    'April',
    'Mei',
    'Juni',
    'Juli',
    'Agustus',
    'September',
    'Oktober',
    'November',
    'Desember'
  );

  if($date != '0000-00-00')
  {
    $split = explode('-', $date); 
    $tgl = $split[2].' '.$bulan[(int)$split[1]].' '.$split[0];
  } 
  else $tgl = '00-00-0000';

  return $tgl;
}


function status($value)
{
  if($value == 'Terkirim')
  {
    $result = '<span class="badge bg-success">'.$value.'</span>';
  }
  else $result = '<span class="badge bg-danger">'.$value.'</span>';

  return $result;
}

function status_bpjs_pemeriksaan($pcare_pemeriksaan, $pcare_pendaftaran)
{
  $value = '';

  if($pcare_pendaftaran == 'Belum terkirim') $value = ' [PCare Pendaftaran belum dikirim]';

  if($pcare_pemeriksaan == 'Terkirim')
  {
    $result = '<span class="badge bg-success">'.$pcare_pemeriksaan.'</span>';
  }
  else if($pcare_pemeriksaan == '')
  {
    $result = '<span class="badge bg-warning">Belum diperiksa</span>';
  }
  else $result = '<span class="badge bg-danger">'.$pcare_pemeriksaan.'</span><br><span class="badge bg-danger">'.$value.'</span>';

  return $result;
}

function debitur($value)
{
  if($value == 'BPJS')
  {
    $result = '<span class="badge bg-success">'.$value.'</span>';
  }
  else $result = '<span class="badge bg-primary">'.$value.'</span>';

  return $result;
}

function pemeriksaan($value)
{
  if($value == 'Belum')
  {
    $result = '<span class="badge bg-warning">'.$value.'</span>';
  }
  else $result = '<span class="badge bg-success">'.$value.'</span>';

  return $result;
}

?>

<div class="table-responsive">
  <table class="table table-sm table-bordered table-striped table-hover">
    <thead>
      <tr>
        <th style="text-align: center; width: 50px">No</th>
        <th style="text-align: center;">Nama</th>
        <th style="text-align: center;">Urut</th>
        <th style="text-align: center;">Tgl. Daftar</th>
        <th style="text-align: center;">Debitur</th>
        <th style="text-align: center;">Status</th>
        <th style="text-align: center; width: 300px">Aksi</th>      
      </tr>
    </thead>
    <tbody>
      <?php $urut = $page; foreach ($data as $key){ $urut++; ?>
        <tr <?php if($key->status_pemeriksaan == 'Sudah') echo 'style="background-color: #ccffcc"'; ?>>
          <td style="text-align: center;"><?php echo $urut ?></td>  
          <td><span style="font-size: 20px"><?php echo $key->nama ?></span><?php echo '<br>('.$key->umur.')'; ?></td> 
          <td style="text-align: center;"><?php echo $key->urut ?></td>      
          <td style="text-align: center;"><?php echo $key->tgl_daftar ?></td>
          <td style="text-align: center;"><?php echo debitur($key->debitur_value); ?></td>
          <td style="text-align: left;">
            PCare : <?php if($key->debitur_value == 'BPJS') echo status_bpjs_pemeriksaan($key->status_kirim_bpjs_pemeriksaan, $key->status_kirim_bpjs) ?>
            <br>
            Pemeriksaan : <?php echo pemeriksaan($key->status_pemeriksaan) ?>
            </td> 
          <td  style="text-align: right;">        
            <?php if ($key->bpjs_rujukLanjut == 'true') { ?>
              <a class="btn btn-sm btn-default" onclick="print_rujukan('<?php echo $key->bpjs_noKunjungan ?>')"><i class="fas fa-print"> Print Rujukan</i></a>
            <?php } if ($key->status_pemeriksaan == 'Sudah') { ?>
              <button class="btn bg-purple btn-xs" onclick="edit_data('<?php echo $key->no_rawat ?>')"><i class="fas fa-stethoscope"></i> Edit Pemeriksaan</button>
              <button class="btn btn-danger btn-rounded btn-xs" data-placement="bottom" title="Hapus data" onclick="hapus_data('<?php echo $key->pemeriksaan_id ?>', '<?php echo $key->nama ?>', '<?php echo $key->umur." - ".$key->tgl_pemeriksaan; ?>')"><i class="fas fa-times"></i></button>
            <?php } else { ?>          
              <button class="btn bg-secondary btn-xs" onclick="panggil('<?php echo strtolower($key->nama) ?>')"><i class="fas fa-volume-up"></i> Panggil</button>
              <button class="btn btn-primary btn-xs" onclick="tambah_data('<?php echo $key->no_rawat ?>')"><i class="fas fa-stethoscope"></i> Tambah Pemeriksaan</button>
            <?php } ?>
          </td>
        </tr> 
      <?php } ?>
    </tbody>
  </table>
</div>

<div class="row">
  <div class="col-12 col-sm-6">
    <p>Jumlah Data: <b><?php echo $jml_data ?></b></p>
  </div>
  <div class="col-12 col-sm-6">
    <?php echo $pagination; ?>
  </div>
</div>

<script type="text/javascript">
  var page_curr = base_url+'<?php echo $page_curr ?>';
  $('.pagination').on('click','a',function(e){
   e.preventDefault(); 
   var url_page = $(this).attr('href');
   url_page = url.protocol+''+url_page.replace('http:', '');
   load_tabel(url_page);
 });
</script>