<?php
defined('BASEPATH') OR exit('No direct script access allowed');

function tgl_convert($date)
{  
  $bulan = array (
    1 =>   'Januari',
    'Februari',
    'Maret',
    'April',
    'Mei',
    'Juni',
    'Juli',
    'Agustus',
    'September',
    'Oktober',
    'November',
    'Desember'
  );

  if($date != '0000-00-00' && $date != '')
  {
    $split = explode('-', $date); 
    $tgl = $split[2].' '.$bulan[(int)$split[1]].' '.$split[0];
  } 
  else $tgl = '00-00-0000';

  return $tgl;
}

?>

<div class="table-responsive">
  <table class="table table-sm table-bordered table-striped table-hover">
    <thead>
      <tr>
        <th style="text-align: center; width: 50px">No</th>
        <th style="text-align: center;">No. RM</th>
        <th style="text-align: center;">Nama Pasien</th>
        <th style="text-align: center;">Tanggal Lahir</th>
        <th style="text-align: center;">No. BPJS</th>
        <th style="text-align: center;">NIK</th>
        <th style="text-align: center;">Keterangan lain</th>
        <th style="text-align: center;">Alamat</th>        
        <th style="text-align: center; width: 120px">Aksi</th>
      </tr>
    </thead>
    <tbody>
      <?php $urut = $page; foreach ($data as $key){ $urut++; ?>
        <tr>
          <td style="text-align: center;"><?php echo $urut ?></td> 
          <td style="text-align: center;"><?php echo $key->no_rm ?></td>  
          <td><?php echo $key->nama ?><br>(<?php if($key->jenis_kelamin == 'L'){ echo 'Laki-laki'; } else echo 'Perempuan'; ?>)</td>
          <td style="text-align: center;"><?php echo tgl_convert($key->tgl_lahir) ?></td> 
          <td style="text-align: center;"><?php echo $key->no_bpjs ?></td>
          <td style="text-align: center;"><?php echo $key->nik ?></td>     
          <td style="text-align: center;"><?php echo $key->keterangan_lain ?></td>            
          <td style="text-align: center;"><?php echo $key->alamat ?></td>
          <td style="text-align: center;">
            <button class="btn bg-purple btn-rounded btn-xs" data-toggle="modal" data-target="#modal-data-xl2" data-backdrop="static" data-keyboard="false" onclick="tambah_data('<?php echo $key->no_rm ?>')"> Daftar</button>
            <button class="btn btn-info btn-rounded btn-xs" data-toggle="modal" data-target="#modal-data-xl" data-backdrop="static" data-keyboard="false" onclick="edit_pasien('<?php echo $key->no_rm ?>')"><i class="fas fa-edit"></i> Edit</button>
          </td>
        </tr> 
      <?php } ?>
    </tbody>
  </table>
</div>

<div class="row">
  <div class="col-12 col-sm-6">
    <p>Jumlah Data: <b><?php echo $jml_data ?></b></p>
  </div>
  <div class="col-12 col-sm-6">
    <?php echo $pagination; ?>
  </div>
</div>

<button type="button" class="btn btn-warning" onclick="batal()"><i class="fas fa-undo"></i> Kembali</button>

<script type="text/javascript">
  var page_curr = base_url+'<?php echo $page_curr ?>';
  $('#<?php echo $table_id ?> .pagination').on('click','a',function(e){
   e.preventDefault(); 
   var url_page = $(this).attr('href');
   url_page = url.protocol+''+url_page.replace('http:', '');
   tabel_pasien(url_page);
 });
</script>