<?php
defined('BASEPATH') OR exit('No direct script access allowed');

$jml_hari = cal_days_in_month(CAL_GREGORIAN, $this->input->post('bulan'), $this->input->post('tahun'));

foreach ($pendaftaran as $key) 
{
    if($key->debitur == 'BPJS') $bpjs = $key;

    if($key->debitur == 'UMUM') $umum = $key;
}

?>

<div id="container" style="height: 400px; width: 100%"></div>

<script type="text/javascript">
   Highcharts.chart('container', {
    chart: {
        type: 'column'
    },
    title: {
        text: 'Grafik Pendaftaran berdasarkan debitur'
    },
    subtitle: {
        text:
        $('select[name=bulan] :selected').text()+' '+$('select[name=tahun]').val()
    },
    xAxis: {
        categories: [<?php for ($i=1; $i <= $jml_hari; $i++){ echo $i.','; } ?>],
        crosshair: true,        
        title: {
            text: 'hari'
        }
    },
    yAxis: {
        min: 0,
        title: {
            text: 'Jumlah Kunjungan'
        }
    },
    tooltip: {
        valueSuffix: ' Kunjungan'
    },
    plotOptions: {
        column: {
            pointPadding: 0.2,
            borderWidth: 0
        }
    },
    series: [
    {
        name: 'BPJS',
        data: [<?php for ($i=1; $i <= $jml_hari; $i++){ if(isset($bpjs)){ $nilai = 'hari_'.$i; echo intval($bpjs->$nilai).','; } else echo '0,'; } ?>]
    },
    {
        name: 'UMUM',
        data: [<?php for ($i=1; $i <= $jml_hari; $i++){ if(isset($umum)){ $nilai = 'hari_'.$i;  echo intval($umum->$nilai).','; } else echo '0,'; } ?>]
    }
    ]
});
</script>