
<!DOCTYPE html>
<html dir="ltr">

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Favicon icon -->
  <link rel="icon" type="image/x-icon" href="<?php echo base_url($pengaturan->url_logo_kecil) ?>">
  <title><?php echo strtoupper($pengaturan->singkatan) ?></title>

  <!-- Custom CSS -->
  <link href="./_asset/theme_login/style.min.css" rel="stylesheet">

</head>

<body>
  <div class="main-wrapper">
    <!-- ============================================================== -->
    <!-- Preloader - style you can find in spinners.css -->
    <!-- ============================================================== -->
    <div class="preloader">
      <div class="lds-ripple">
        <div class="lds-pos"></div>
        <div class="lds-pos"></div>
      </div>
    </div>
    <!-- ============================================================== -->
    <!-- Preloader - style you can find in spinners.css -->
    <!-- ============================================================== -->
    <!-- ============================================================== -->
    <!-- Login box.scss -->
    <!-- ============================================================== -->
    <div class="auth-wrapper d-flex no-block justify-content-center align-items-center" style="background:url(_asset/theme_login/auth-bg.jpg) no-repeat center center;">
      <div class="auth-box">
        <div id="loginform">
          <div class="logo">
            <p><span class="db"><img src="<?php echo base_url($pengaturan->url_logo_besar) ?>" alt="logo" style="width: 150px" /></span></p>
            <h2 class="font-medium m-b-20" style="text-transform: uppercase;"><?php echo $pengaturan->nama ?></h2>
            <h5 class="font-medium m-b-20" style="text-transform: uppercase;"><?php echo $pengaturan->perusahaan ?></h5>
          </div>
          <!-- Form -->
          <div class="row">
            <div class="col-12">
              <p style="color: red" id="notifikasi"></p> 
              <form action="<?php echo base_url('login/proses_login') ?>" method="POST" id="form-data">
                <div class="input-group mb-3">
                  <div class="input-group-prepend">
                    <span class="input-group-text" id="basic-addon1"><i class="ti-user"></i></span>
                  </div>
                  <input type="text" class="form-control form-control-lg" placeholder="Username" aria-label="Username" aria-describedby="basic-addon1" name="username">
                </div>
                <div class="input-group mb-3">
                  <div class="input-group-prepend">
                    <span class="input-group-text" id="basic-addon2"><i class="ti-key"></i></span>
                  </div>
                  <input type="password" class="form-control form-control-lg" placeholder="Password" aria-label="Password" aria-describedby="basic-addon1" name="password">
                </div>
                <div class="form-group text-center">
                  <div class="col-xs-12 p-b-20">
                    <button class="btn btn-block btn-lg btn-info" type="submit">Log In</button>
                  </div>
                </div>
              </form>
            </div>
          </div>
        </div>
      </div>
    </div>

  </div>
  <script src="./_asset/theme_login/jquery.min.js"></script>
  <!-- Bootstrap tether Core JavaScript -->
  <script src="./_asset/theme_login/popper.min.js"></script>
  <script src="./_asset/theme_login/bootstrap.min.js"></script>
  <script>
    $('[data-toggle="tooltip"]').tooltip();
    $(".preloader").fadeOut();
    var base_url = '<?php echo base_url(); ?>';
  </script>

  <script type="text/javascript">

    var base_url = '<?php echo base_url(); ?>';
    $('#form-data').submit(function(e){
      e.preventDefault();      
      var data = $(this).serialize();
      $('.add_data').attr('disabled', true);
      $.ajax({
        type: $('#form-data').attr('method'),
        url: $('#form-data').attr('action'),
        data: data,
        dataType:'json',
        success: function(response){
          if(response.eror == 'success'){             
            $('#notifikasi').html(response.pesan);   
            window.location.href = base_url;     
          } else {
            $('#notifikasi').html(response.pesan);          
            $('.add_data').attr('disabled', false);
          }
        },
        error: function (xhr, ajaxOptions, thrownError) { 
         console.log(xhr.responseText);
         $('.add_data').attr('disabled', false);
       }  
     });
    })

  </script>
</body>

</html>