<?php
defined('BASEPATH') OR exit('No direct script access allowed');
?>

<div class="modal-content">
  <div class="modal-header">
    <h4 class="modal-title" id="modal-title"></h4>
    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
      <span aria-hidden="true">&times;</span>
    </button>
  </div>
  <div class="modal-body">
    <div class="row">          
      <div class="col-12 col-sm-12 col-md-12 col-lg-4">
        <div class="form-group">
          <div class="input-group input-group-sm">
            <div class="input-group-prepend">
              <span class="input-group-text">Poli </span>
            </div>
            <select class="form-control form-control-sm" name="bpjs_kdPoli" required> 
              <option value="" selected hidden disabled></option>
              <?php foreach ($select_poli as $key){ ?>                
                <option value="<?php echo $key->kdPoli ?>"><?php echo $key->nmPoli ?></option>
              <?php } ?>                     
            </select>     
          </div>
        </div>           
      </div>
      <div class="col-12 col-sm-12 col-md-12 col-lg-4">
        <div class="form-group">
          <div class="input-group input-group-sm">
            <input type="text" class="form-control form-control-sm" name="tgl" id="date_tgl" data-target="#date_tgl" data-toggle="datetimepicker" value="<?php echo date('Y-m-d') ?>"  required/>    
            <div class="input-group-append">
              <span class="input-group-text"><i class="fas fa-calendar-alt"></i></span>
            </div>  
          </div>    
        </div>
      </div>
      <div class="col-12 col-sm-12 col-md-12 col-lg-4">
        <div class="form-group">
          <button type="submit" class="btn btn-sm btn-primary" onclick="cek()"><i class="fas fa-search"></i> Cek</button>
        </div>
      </div>
      <div class="col-12 col-sm-12 col-md-12 col-lg-12">
        <div id="content_table"></div>
      </div>
    </div>
  </div>
  <div class="modal-footer">
    <button type="button" class="btn btn-default" data-dismiss="modal" class="close"><i class="fas fa-times"></i> Batal</button>
  </div>
</div>

<script>
  $(document).ready(function(){    
    $('.select2').select2();
  })

  $(document).on('mouseup touchend', function (e) {
    var container = $(".bootstrap-datetimepicker-widget");
    if (!container.is(e.target) && container.has(e.target).length === 0) {
      container.hide();
    }
  });

  $('#date_tgl').datetimepicker({    
    focusOnShow: true,
    format: 'Y-MM-DD'
  })

  function cek()
  {
    var data = {
      service_name : 'referensi_dokter_antrol',
      tgl: $('input[name=tgl]').val(),
      kdPoli: $('select[name=bpjs_kdPoli]').val()
    };

    $.ajax({
      url: base_url+'data_bpjs/tabel_service',
      type: 'POST',
      data: data,
      dataType:'json',
      success: function(response){ 
        $('#content_table').html(response.data);
      },
      error: function (xhr, ajaxOptions, thrownError) {
        console.log(xhr.responseText);
      }
    });
  }

</script>
