<?php
defined('BASEPATH') OR exit('No direct script access allowed');
?>

<form role="form" method="POST" id="form-data_1" action="<?php echo $url_form_1 ?>">
  <div class="card card-primary card-outline card-outline-tabs">
    <div class="card-header p-0 border-bottom-0">
      <ul class="nav nav-tabs" id="custom-tabs-four-tab" role="tablist">
        <li class="nav-item">
          <a class="nav-link active" id="custom-tabs-aplikasi-tab" data-toggle="pill" href="#custom-tabs-aplikasi" role="tab" aria-controls="custom-tabs-aplikasi" aria-selected="true">Aplikasi</a>
        </li>
        <li class="nav-item">
          <a class="nav-link" id="custom-tabs-bpjs-tab" data-toggle="pill" href="#custom-tabs-bpjs" role="tab" aria-controls="custom-tabs-bpjs" aria-selected="false">BPJS</a>
        </li>
        <li class="nav-item">
          <a class="nav-link" id="custom-tabs-satusehat-tab" data-toggle="pill" href="#custom-tabs-satusehat" role="tab" aria-controls="custom-tabs-satusehat" aria-selected="false">Satu Sehat</a>
        </li>
      </ul>
    </div>
    <div class="card-body" id="content-tabel-1"> 
      <div class="tab-content" id="custom-tabs-four-tabContent">
        <div class="tab-pane fade show active" id="custom-tabs-aplikasi" role="tabpanel" aria-labelledby="custom-tabs-aplikasi-tab">
          <div class="row">
            <div class="col-md-6 col-12">                  
              <div class="form-group">
                <label>Nama <span class="text-red">*</span></label>
                <input type="text" class="form-control form-control-sm" name="nama" placeholder="Enter name" value="<?php echo $data->nama ?>" required>
              </div>
              <div class="form-group">
                <label>Singkatan <span class="text-red">*</span></label>
                <input type="text" class="form-control form-control-sm" name="singkatan" placeholder="Enter singkatan" value="<?php echo $data->singkatan ?>" required>
              </div>
              <div class="form-group">
                <label>Perusahaan <span class="text-red">*</span></label>
                <input type="text" class="form-control form-control-sm" name="perusahaan" placeholder="Enter perusahaan" value="<?php echo $data->perusahaan ?>" required>
              </div>  
              <div class="form-group">
                <label>No. Telp</label>
                <input type="text" class="form-control form-control-sm" name="no_telp" value="<?php echo $data->no_telp ?>" placeholder="Enter no telp.">
              </div>  
              <div class="form-group">
                <label>Alamat</label>
                <textarea class="form-control form-control-sm" name="alamat" rows="2"><?php echo $data->alamat ?></textarea>
              </div> 
              <div class="form-group">
                <label>Email</label>
                <input type="text" class="form-control form-control-sm" name="email" value="<?php echo $data->email ?>" placeholder="Enter email">
              </div> 
            </div>
            <div class="col-md-6 col-12">             
              <div class="form-group">
                <label>Kode Klinik</label>
                <select class="form-control form-control-sm" name="kode_klinik" required> 
                  <option value="RJ" <?php if($data->kode_klinik == 'RJ'){ echo 'selected'; } ?>>Rawat Jalan (RJ)</option>
                  <option value="RJRI" <?php if($data->kode_klinik == 'RJRI'){ echo 'selected'; } ?>>Rawat Jalan + Rawat Inap (RJRI)</option>
                </select>
              </div>   
              <div class="form-group">
                <label>Kode Lab</label>
                <select class="form-control form-control-sm" name="kode_lab" required> 
                  <option value="LAB" <?php if($data->kode_klinik == 'LAB'){ echo 'selected'; } ?>>LAB</option>
                </select>
              </div>   
              <div class="form-group">
                <label>Kode Farmasi</label>
                <select class="form-control form-control-sm" name="kode_farmasi" required> 
                  <option value="APT" <?php if($data->kode_klinik == 'APT'){ echo 'selected'; } ?>>APT</option>
                </select>
              </div>  
              <div class="form-group">
                <label>Kode Waktu</label>
                <select class="form-control form-control-sm" name="kode_waktu" required> 
                  <option value="+07:00" <?php if($data->kode_waktu == '+07:00'){ echo 'selected'; } ?>>WIB (+07:00)</option>
                  <option value="+08:00" <?php if($data->kode_waktu == '+08:00'){ echo 'selected'; } ?>>WITA (+08:00)</option>
                  <option value="+09:00" <?php if($data->kode_waktu == '+09:00'){ echo 'selected'; } ?>>WIT (+09:00)</option>
                </select>
              </div>    
              <div class="form-group">
                <label>RM Terakhir</label>
                <input type="text" class="form-control form-control-sm" name="last_no_rm" value="<?php echo $data->last_no_rm ?>" placeholder="Enter rm terkahir">
              </div> 
              <div class="form-group">
                <label>Versi Aplikasi</label>
                <div class="input-group input-group-sm">                  
                  <input type="text" class="form-control form-control-sm" name="versi" value="<?php echo $data->versi ?>" readonly>
                  <span class="input-group-append">
                    <button type="button" class="btn btn-danger btn-flat" data-toggle="modal" data-target="#modal-data-xl" data-backdrop="static" data-keyboard="false" onclick="update_get_from_server('all', <?php echo $data->versi ?>)"><i class='fas fa-download'></i> Update All</button>                      
                    <button type="button" class="btn btn-warning btn-flat dropdown-toggle" data-toggle="dropdown" aria-expanded="false"><i class='fas fa-file'></i> Update File</button>
                    <ul class="dropdown-menu" style="">
                      <li class="dropdown-item"><a class="btn" data-toggle="modal" data-target="#modal-data-xl" data-backdrop="static" data-keyboard="false" onclick="update_get_from_server('file_all', <?php echo $data->versi ?>)">Semua</a></li>
                      <li class="dropdown-item"><a class="btn"  data-toggle="modal" data-target="#modal-data-xl" data-backdrop="static" data-keyboard="false" onclick="update_get_from_server('file_last', <?php echo $data->versi ?>)">Terbaru</a></li>
                    </ul>

                    <?php if($this->session->userdata('class_'.$this->session->userdata('prefix')) == 'admin'){  ?>

                      <button type="button" class="btn btn-info btn-flat" onclick="backup_database()"><i class='fas fa-database'></i> 
                      Backup Database</button>

                    <?php } ?>
                  </span>
                </div>
              </div>
            </div>
            <div class="col-md-6 col-12"> 
              <div class="form-group">
                <label for="customFile">Logo Kecil</label>
                <div class="custom-file">
                  <input type="hidden" name="url_logo_kecil" value="<?php echo $data->url_logo_kecil ?>">
                  <input type="file" class="custom-file-input" id="logo_kecil" name="logo_kecil">
                  <label class="custom-file-label" for="logo_kecil">Choose file</label>
                </div>
              </div>
              <img width="100" src="./<?php echo $data->url_logo_kecil ?>">
            </div>
            <div class="col-md-6 col-12"> 
              <div class="form-group">
                <label for="customFile">Logo Header Surat</label>
                <div class="custom-file">
                  <input type="hidden" name="url_logo_header" value="<?php echo $data->url_logo_header ?>">
                  <input type="file" class="custom-file-input" id="logo_header" name="logo_header">
                  <label class="custom-file-label" for="logo_header">Choose file</label>
                </div>
              </div>
              <img width="100" src="./<?php echo $data->url_logo_header ?>">
            </div>
            <div class="col-md-6 col-12"> 
              <div class="form-group">
                <label for="customFile">Logo Besar</label>
                <div class="custom-file">
                  <input type="hidden" name="url_logo_besar" value="<?php echo $data->url_logo_besar ?>">
                  <input type="file" class="custom-file-input" id="logo_besar" name="logo_besar">
                  <label class="custom-file-label" for="logo_besar">Choose file</label>
                </div>
              </div>
              <img width="200" src="./<?php echo $data->url_logo_besar ?>">
            </div>
            <div class="col-md-6 col-12">  
              <div class="form-group">
                <label>Footer</label>
                <input type="footer" class="form-control form-control-sm" name="footer" value="<?php echo $data->footer ?>" placeholder="Enter footer">
              </div> 
            </div>
          </div>
          <p class="text-red"> * Wajib diisi</p>  
        </div>
        <div class="tab-pane fade" id="custom-tabs-bpjs" role="tabpanel" aria-labelledby="custom-tabs-bpjs-tab">        
          <div class="form-group">
            <label>Kode PPK</label>
            <input type="text" class="form-control form-control-sm" name="bpjs_kode_ppk" value="<?php echo $data->bpjs_kode_ppk ?>" placeholder="Enter kode ppk">
          </div> 
          <div class="form-group">
            <label>Cons ID</label>
            <input type="text" class="form-control form-control-sm" name="bpjs_cons_id" value="<?php echo $data->bpjs_cons_id ?>" placeholder="Enter cons id">
          </div> 
          <div class="form-group">
            <label>Secret Key</label>
            <input type="secret_key" class="form-control form-control-sm" name="bpjs_secret_key" value="<?php echo $data->bpjs_secret_key ?>" placeholder="Enter secret key">
          </div> 
          <div class="form-group">
            <label>User Key</label>
            <input type="text" class="form-control form-control-sm" name="bpjs_user_key" value="<?php echo $data->bpjs_user_key ?>" placeholder="Enter user key">
          </div> 
          <div class="form-group">
            <label>Username PCARE</label>
            <input type="text" class="form-control form-control-sm" name="bpjs_username_pcare" value="<?php echo $data->bpjs_username_pcare ?>" placeholder="Enter username pcare">
          </div> 
          <div class="form-group">
            <label>Password PCARE</label>
            <input type="text" class="form-control form-control-sm" name="bpjs_password_pcare" value="<?php echo $data->bpjs_password_pcare ?>" placeholder="Enter password pcare">
          </div>  
          <div class="form-group">
            <label>URL Service PCARE</label>
            <input type="text" class="form-control form-control-sm" name="bpjs_url_pcare" value="<?php echo $data->bpjs_url_pcare ?>" placeholder="Enter url service pcare">
          </div> 
          <div class="form-group">
            <label>URL Service Antrol</label>
            <input type="text" class="form-control form-control-sm" name="bpjs_url_antrol" value="<?php echo $data->bpjs_url_antrol ?>" placeholder="Enter url service antrol">
          </div> 
          <div class="form-group">
            <label>Username JKN</label>
            <input type="text" class="form-control form-control-sm" name="bpjs_username_jkn" value="<?php echo $data->bpjs_username_jkn ?>" placeholder="Enter username jkn">
          </div> 
          <div class="form-group">
            <label>Password JKN</label>
            <input type="text" class="form-control form-control-sm" name="bpjs_password_jkn" value="<?php echo $data->bpjs_password_jkn ?>" placeholder="Enter password jkn">
          </div>  
          <div class="form-group">
            <label>Hari JKN</label>
            <input type="number" class="form-control form-control-sm" name="bpjs_hari_jkn" value="<?php echo $data->bpjs_hari_jkn ?>" placeholder="Enter hari jkn">
          </div>  
          <div class="form-group">
            <label>Kuota JKN</label>
            <input type="number" class="form-control form-control-sm" name="bpjs_kuota_jkn" value="<?php echo $data->bpjs_kuota_jkn ?>" placeholder="Enter kuota jkn">
          </div>  
          <div class="form-group">
            <label>URL Service JKN</label>
            <input type="text" class="form-control form-control-sm" name="bpjs_url_jkn" value="<?php echo $data->bpjs_url_jkn ?>" placeholder="Enter url service jkn">
          </div> 
          <div class="form-group">
            <label>Username ICARE</label>
            <input type="text" class="form-control form-control-sm" name="bpjs_username_icare" value="<?php echo $data->bpjs_username_icare ?>" placeholder="Enter username icare">
          </div> 
          <div class="form-group">
            <label>Password ICARE</label>
            <input type="text" class="form-control form-control-sm" name="bpjs_password_icare" value="<?php echo $data->bpjs_password_icare ?>" placeholder="Enter password icare">
          </div> 
          <div class="form-group">
            <label>URL Service ICARE</label>
            <input type="text" class="form-control form-control-sm" name="bpjs_url_icare" value="<?php echo $data->bpjs_url_icare ?>" placeholder="Enter url service icare">
          </div>  
        </div>
        <div class="tab-pane fade" id="custom-tabs-satusehat" role="tabpanel" aria-labelledby="custom-tabs-satusehat-tab">
          <div class="form-group">
            <label>ID</label>
            <input type="text" class="form-control form-control-sm" name="satusehat_id" value="<?php echo $data->satusehat_id ?>" placeholder="Enter satusehat id">
          </div> 
          <div class="form-group">
            <label>Client ID</label>
            <input type="text" class="form-control form-control-sm" name="satusehat_client_id" value="<?php echo $data->satusehat_client_id ?>" placeholder="Enter satusehat client id">
          </div> 
          <div class="form-group">
            <label>Secret Key</label>
            <input type="text" class="form-control form-control-sm" name="satusehat_secret_key" value="<?php echo $data->satusehat_secret_key ?>" placeholder="Enter satusehat secret id">
          </div>          
          <div class="form-group">
            <label>Propinsi</label>                   
            <select class="form-control select2" name="satusehat_propinsi" style="width: 100%;" required>                       
              <option value="-">-</option>
              <?php foreach ($select_propinsi as $key){  ?>
                <option value="<?php echo $key->id ?>" <?php if($key->id == $data->satusehat_propinsi){ echo 'selected'; } ?>><?php echo $key->value ?></option>
              <?php } ?>
            </select>
          </div>
          <div class="form-group">
            <label>Kota/Kab</label>                 
            <select class="form-control select2" name="satusehat_kabupaten" style="width: 100%;" required>           
              <option value="-">-</option>
              <?php foreach ($select_kabupaten as $key){  ?>
                <option value="<?php echo $key->id ?>"  <?php if($key->id == $data->satusehat_kabupaten){ echo 'selected'; } ?>><?php echo $key->value ?></option>
              <?php } ?>
            </select>
          </div>
          <div class="form-group">
            <label>Kecamatan</label>                   
            <select class="form-control select2" name="satusehat_kecamatan" style="width: 100%;" required>           
              <option value="-">-</option>
              <?php foreach ($select_kecamatan as $key){  ?>
                <option value="<?php echo $key->id ?>"  <?php if($key->id == $data->satusehat_kecamatan){ echo 'selected'; } ?>><?php echo $key->value ?></option>
              <?php } ?>
            </select>
          </div>
          <div class="form-group">
            <label>Kelurahan</label>                      
            <select class="form-control select2" name="satusehat_kelurahan" style="width: 100%;" required>           
              <option value="-">-</option>
              <?php foreach ($select_kelurahan as $key){  ?>
                <option value="<?php echo $key->id ?>"  <?php if($key->id == $data->satusehat_kelurahan){ echo 'selected'; } ?>><?php echo $key->value ?></option>
              <?php } ?>
            </select>
          </div> 
          <div class="form-group">
            <label>Kode Pos</label>
            <input type="text" class="form-control form-control-sm" name="satusehat_kodepos" value="<?php echo $data->satusehat_kodepos ?>" placeholder="Enter satusehat kode pos">
          </div> 
          <div class="form-group">
            <label>RT</label>
            <input type="text" class="form-control form-control-sm" name="satusehat_rt" value="<?php echo $data->satusehat_rt ?>" placeholder="Enter satusehat rt">
          </div>
          <div class="form-group">
            <label>RW</label>
            <input type="text" class="form-control form-control-sm" name="satusehat_rw" value="<?php echo $data->satusehat_rw ?>" placeholder="Enter satusehat rw">
          </div>
          <div class="form-group">
            <label>URL Auth</label>
            <input type="text" class="form-control form-control-sm" name="satusehat_url_auth" value="<?php echo $data->satusehat_url_auth ?>" placeholder="Enter satusehat url auth">
          </div> 
          <div class="form-group">
            <label>URL Fhir</label>
            <input type="text" class="form-control form-control-sm" name="satusehat_url_fhir" value="<?php echo $data->satusehat_url_fhir ?>" placeholder="Enter satusehat url fhir">
          </div>
          <div class="form-group">
            <a class="btn btn-info btn-xs" onclick="get_token()"><i class="fas fa-download"></i> Get Token</a>
          </div>
        </div>
      </div>
    </div>

    <div class="card-footer">
      <div style="text-align: right; width: 100%">
        <button type="submit" class="btn btn-primary add_data"><i class="fas fa-save"></i> Simpan</button>
      </div>
    </div>
  </div>
</form>

<script>
  $(document).ready(function(){    
    $('.select2').select2();
  })

  $(document).on('mouseup touchend', function (e) {
    var container = $(".bootstrap-datetimepicker-widget");
    if (!container.is(e.target) && container.has(e.target).length === 0) {
      container.hide();
    }
  });
  
  function select_propinsi(data){
    $.ajax({
      url: base_url+'wilayah/select_kode_kabupaten/'+data,
      success: function(response){
        $('select[name=kabupaten]').html(response);
        $('select[name=kecamatan]').html('');
        $('select[name=kelurahan]').html('');
      },
      error: function (xhr, ajaxOptions, thrownError) { 
        console.log(xhr.responseText);
      } 
    }); 
  }

  $('select[name=kabupaten]').change(function() {
    select_kabupaten($(this).val());
  });

  function select_kabupaten(data){
    $.ajax({
      url: base_url+'wilayah/select_kode_kecamatan/'+data,
      success: function(response){
        $('select[name=kecamatan]').html(response);
        $('select[name=kelurahan]').html('');
      },
      error: function (xhr, ajaxOptions, thrownError) { 
        console.log(xhr.responseText);
      } 
    });
  }

  $('select[name=kecamatan]').change(function() {
    select_kecamatan($(this).val());
  });

  function select_kecamatan(data){
    $.ajax({
      url: base_url+'wilayah/select_kode_kelurahan/'+data,
      success: function(response){
        $('select[name=kelurahan]').html(response);
      },
      error: function (xhr, ajaxOptions, thrownError) { 
        console.log(xhr.responseText);
      } 
    });
  }

  $('#form-data_1').submit(function(e){
    e.preventDefault();
    $('.add_data').attr('disabled', true);  
    $.ajax({
      type: $('#form-data_1').attr('method'),
      url: base_url+''+$('#form-data_1').attr('action'),
      data:new FormData(this),
      processData:false,
      contentType:false,
      cache:false,
      async:false,
      dataType:'json',
      success: function(response){
        notif(response.eror,response.pesan);
        $('.add_data').attr('disabled',false);
      },
      error: function (xhr, ajaxOptions, thrownError) {
        console.log(xhr.responseText);
        $('.add_data').attr('disabled',false);
      }  
    });
  })
</script>
