<?php
defined('BASEPATH') OR exit('No direct script access allowed');  
?>

<form role="form" method="POST" id="form-data" action="<?php echo $url_form ?>">
  <div class="card-content">
    <div class="card-header" style="background-color: #b3d1ff">
      <h3 class="card-title">Pengaturan Pemeriksaan</h3>
    </div>
    <div class="card-body">
      <div class="row">  
      <div class="col-12">
        <div class="card">
          <div class="card-header bg-olive" style="height: 30px; padding: 5px">
            <h4 class="card-title">PEMERIKSAAN DOKTER</h4>
          </div>
          <div class="card-body">
            <div class="row"> 
              <div class="col-12 col-sm-6 col-md-6 col-lg-3">
                <div class="form-group">
                  <label>Subject (Keluhan) <span class="badge bg-success">BPJS</span></label>
                  <textarea class="form-control form-control-sm" name="bpjs_keluhan" placeholder="keluhan" rows="3"><?php echo $data->bpjs_keluhan ?></textarea>
                </div>  
              </div>
              <div class="col-12 col-sm-6 col-md-6 col-lg-3">             
                <div class="form-group">
                  <label>Object</label>
                  <textarea class="form-control form-control-sm" name="object" placeholder="object" rows="3"><?php echo $data->object ?></textarea>
                </div>     
              </div>
              <div class="col-12 col-sm-6 col-md-6 col-lg-3"> 
                <div class="form-group">
                  <label>Asesmen <span class="badge bg-success">BPJS</span> <span class="badge bg-primary">SS</span></label>
                  <textarea class="form-control form-control-sm" name="bpjs_anamnesa" placeholder="anamnesa" rows="3"><?php echo $data->bpjs_anamnesa ?></textarea>
                </div>  
              </div>
              <div class="col-12 col-sm-6 col-md-6 col-lg-3"> 
                <div class="form-group">
                  <label>Plan</label>
                  <textarea class="form-control form-control-sm" name="plan" placeholder="plan" rows="3"><?php echo $data->plan ?></textarea>
                </div>       
              </div>
              <div class="col-12 col-sm-6 col-md-6 col-lg-3">            
                <div class="form-group">
                  <label>Intruksi (Terapi Obat) <span class="badge bg-success">BPJS</span> <span class="badge bg-primary">SS</span></label>
                  <textarea class="form-control form-control-sm" name="bpjs_terapiObat" placeholder="terapi obat otamatis terisi saat input pemberian obat" rows="3" readonly><?php echo $data->bpjs_terapiObat ?></textarea>
                </div>     
              </div>
              <div class="col-12 col-sm-6 col-md-6 col-lg-3">
                <div class="form-group">
                  <label>Terapi Non Obat <span class="badge bg-success">BPJS</span></label>
                  <textarea class="form-control form-control-sm" name="bpjs_terapiNonObat" placeholder="terapi non obat" rows="3"><?php echo $data->bpjs_terapiNonObat ?></textarea>
                </div>                                     
              </div>
              <div class="col-12 col-sm-6 col-md-6 col-lg-3">
                <div class="form-group">
                  <label>BMHP <span class="badge bg-success">BPJS</span></label>
                  <textarea class="form-control form-control-sm" name="bpjs_bmhp" placeholder="bmhp" rows="3"><?php echo $data->bpjs_bmhp ?></textarea>
                </div>        
              </div>
              <div class="col-12 col-sm-6 col-md-6 col-lg-3">      
                <div class="form-group">
                  <label>Evaluasi</label>
                  <textarea class="form-control form-control-sm" name="evaluasi" placeholder="evaluasi" rows="3"><?php echo $data->evaluasi ?></textarea>
                </div>   
              </div>
              <div class="col-12 col-sm-6 col-md-6 col-lg-6">
                <div class="form-group">
                  <label>Alergi Makanan <span class="badge bg-success">BPJS</span></label>
                  <div class="row">
                    <?php foreach ($select_alergi_makanan as $key){ ?>                     
                      <div class="col-12 col-sm-6 col-md-6 col-lg-6">              
                        <div class="form-check">
                          <input class="form-check-input" type="radio" id="radio_alergiMakan_<?php echo $key->kdAlergi ?>" name="bpjs_alergiMakan" value="<?php echo $key->kdAlergi ?>" <?php if($data->bpjs_alergiMakan == $key->kdAlergi){ echo 'checked'; } ?>>
                          <label class="form-check-label" for="radio_alergiMakan_<?php echo $key->kdAlergi ?>"><?php echo $key->nmAlergi ?></label>
                        </div>
                      </div>
                    <?php } ?>
                  </div>
                </div> 
                <div class="form-group">
                  <label>Alergi Udara <span class="badge bg-success">BPJS</span></label>
                  <div class="row">
                    <?php foreach ($select_alergi_udara as $key){ ?>                     
                      <div class="col-12 col-sm-6 col-md-6 col-lg-6">              
                        <div class="form-check">
                          <input class="form-check-input" type="radio" id="radio_alergiUdara_<?php echo $key->kdAlergi ?>" name="bpjs_alergiUdara" value="<?php echo $key->kdAlergi ?>" <?php if($data->bpjs_alergiUdara == $key->kdAlergi){ echo 'checked'; } ?>>
                          <label class="form-check-label" for="radio_alergiUdara_<?php echo $key->kdAlergi ?>"><?php echo $key->nmAlergi ?></label>
                        </div>
                      </div>
                    <?php } ?>
                  </div>
                </div> 
                <div class="form-group">
                  <label>Alergi Obat <span class="badge bg-success">BPJS</span></label>
                  <div class="row">
                    <?php foreach ($select_alergi_obat as $key){ ?>                     
                      <div class="col-12 col-sm-6 col-md-6 col-lg-6">              
                        <div class="form-check">
                          <input class="form-check-input" type="radio" id="radio_alergiObat_<?php echo $key->kdAlergi ?>" name="bpjs_alergiObat" value="<?php echo $key->kdAlergi ?>" <?php if($data->bpjs_alergiObat == $key->kdAlergi){ echo 'checked'; } ?>>
                          <label class="form-check-label" for="radio_alergiObat_<?php echo $key->kdAlergi ?>"><?php echo $key->nmAlergi ?></label>
                        </div>
                      </div>
                    <?php } ?>
                  </div>
                </div>
              </div>     
              <div class="col-12 col-sm-6 col-md-6 col-lg-6">
                <div class="form-group">
                  <label>Kesadaran <span class="badge bg-success">BPJS</span></label>
                  <div class="row">
                    <?php foreach ($select_kesadaran as $key){ ?>                     
                      <div class="col-12 col-sm-6 col-md-6 col-lg-6">              
                        <div class="form-check">
                          <input class="form-check-input" type="radio" id="radio_kdSadar_<?php echo $key->kdSadar ?>" name="bpjs_kdSadar" value="<?php echo $key->kdSadar ?>" <?php if($data->bpjs_kdSadar == $key->kdSadar){ echo 'checked'; } ?>>
                          <label class="form-check-label" for="radio_kdSadar_<?php echo $key->kdSadar ?>"><?php echo $key->nmSadar ?></label>
                        </div>
                      </div>
                    <?php } ?>
                  </div>
                </div> 
                <div class="form-group">
                  <label>Prognosa <span class="badge bg-success">BPJS</span></label>
                  <div class="row">
                    <?php foreach ($select_prognosa as $key){ ?>                     
                      <div class="col-12">              
                        <div class="form-check">
                          <input class="form-check-input" type="radio" id="radio_kdPrognosa_<?php echo $key->kdPrognosa ?>" name="bpjs_kdPrognosa" value="<?php echo $key->kdPrognosa ?>" <?php if($data->bpjs_kdPrognosa == $key->kdPrognosa){ echo 'checked'; } ?>>
                          <label class="form-check-label" for="radio_kdPrognosa_<?php echo $key->kdPrognosa ?>"><?php echo $key->nmPrognosa ?></label>
                        </div>
                      </div>
                    <?php } ?>
                  </div>
                </div>   
                <div class="form-group">
                  <label>Status Pulang <span class="badge bg-success">BPJS</span></label>
                  <div class="row">
                    <?php foreach ($select_status_pulang as $key){ ?>                   
                      <div class="col-12 col-sm-6 col-md-6 col-lg-6"> 
                        <div class="form-check">
                          <input class="form-check-input" type="radio" id="radio_kdStatusPulang_<?php echo $key->kdStatusPulang ?>" name="bpjs_kdStatusPulang" value="<?php echo $key->kdStatusPulang ?>" <?php if($data->bpjs_kdStatusPulang == $key->kdStatusPulang){ echo 'checked'; } ?> onchange="checked_kdStatusPulang(this.value)">
                          <label class="form-check-label" for="radio_kdStatusPulang_<?php echo $key->kdStatusPulang ?>"><?php echo $key->nmStatusPulang ?></label>
                        </div>
                      </div>
                    <?php } ?>
                  </div>
                </div>  
              </div>            
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="card-footer">
      <table width="100%">
        <tr>
          <td align="left"><span class="text-red" style="text-align: left;"> * Wajib diisi</span></td>
          <td align="right">
            <input type="hidden" name="id" value="<?php echo $data->id ?>">
            <input type="hidden" name="bpjs_nmSadar" value="<?php echo $data->bpjs_nmSadar?>">
            <input type="hidden" name="bpjs_nmStatusPulang" value="<?php echo $data->bpjs_nmStatusPulang ?>">
            <input type="hidden" name="bpjs_nm_alergiMakan" value="<?php echo $data->bpjs_nm_alergiMakan ?>">
            <input type="hidden" name="bpjs_nm_alergiUdara" value="<?php echo $data->bpjs_nm_alergiUdara ?>">
            <input type="hidden" name="bpjs_nm_alergiObat" value="<?php echo $data->bpjs_nm_alergiObat ?>">
            <input type="hidden" name="bpjs_nmPrognosa" value="<?php echo $data->bpjs_nmPrognosa ?>">
            <input type="hidden" name="bpjs_nmPrognosa" value="<?php echo $data->bpjs_nmPrognosa ?>">
            <button type="submit" class="btn btn-primary add_data"><i class="fas fa-save"></i> Simpan</button> 
            <button type="button" class="btn btn-warning" onclick="batal()"><i class="fas fa-undo"></i> Kembali</button>
          </td>
        </tr>
      </table>      
    </div>
  </div>
</div>
</form>

<script>
  $(document).ready(function()
  {    
    $('.select2').select2();

    $('.select_diagnosa').select2({
      minimumInputLength: 2, 
      language: {
        inputTooShort: function() {
          return 'silakan ketik minimal 2 karakter';
        }
      },
      ajax: {
        url: function (params) {
          return base_url+'select/select_icd10/'+params.term;
        },
        dataType: 'json',
        data: null,
        processResults: function (data) {
          return {
            results: data
          };
        }
      }
    });
  })

  function get_value_input()
  { 
    $('input[name=bpjs_nmSadar]').val($('input[name=bpjs_kdSadar]:checked').next('label:first').html());
    $('input[name=bpjs_nmStatusPulang]').val($('input[name=bpjs_kdStatusPulang]:checked').next('label:first').html());
    $('input[name=bpjs_nm_alergiMakan]').val($('input[name=bpjs_alergiMakan]:checked').next('label:first').html());
    $('input[name=bpjs_nm_alergiUdara]').val($('input[name=bpjs_alergiUdara]:checked').next('label:first').html());
    $('input[name=bpjs_nm_alergiObat]').val($('input[name=bpjs_alergiObat]:checked').next('label:first').html());
    $('input[name=bpjs_nmPrognosa]').val($('input[name=bpjs_kdPrognosa]:checked').next('label:first').html());
  }

  $('#form-data').submit(function(e){
    e.preventDefault();
    get_value_input();
    $('.add_data').attr('disabled', true); 
    $.ajax({
      type: $('#form-data').attr('method'),
      url: base_url+''+$('#form-data').attr('action'),
      data:new FormData(this),
      processData:false,
      contentType:false,
      cache:false,
      async:false,
      dataType:'json',
      success: function(response)
      {
        notif(response.eror, response.pesan);

        if(response.eror == 'success')
        {
          load_tabel();
        } 
        else console.log(response);

        $('.add_data').attr('disabled',false);
      },
      error: function (xhr, ajaxOptions, thrownError) {
        console.log(xhr.responseText);
        $('.add_data').attr('disabled',false);
      }  
    }); 
  })

</script>
