$(document).ready(function(){
  load_tabel();
})  

$('.cari_data').keyup(function(){ 
  load_tabel();
});

function load_tabel(url_page)
{
  if(url_page == null) var url_page = controller_url+'/tabel';

  var data = {
    range_tgl: $('input[name=range_tgl]').val(),
    penyerahan_obat: $('select[name=penyerahan_obat]').val(),
    keyword: $('input[name=keyword]').val()
  };

  $.ajax({
    url: url_page,
    type: 'POST',
    data: data,
    success: function(response){    
      $('#content-tabel-1').html(response);
    },
    error: function (xhr, ajaxOptions, thrownError) { 
     console.log(xhr.responseText);
   }
 });
}

const rupiah = (number)=>{
  return new Intl.NumberFormat("id-ID", {
    style: "currency",
    minimumFractionDigits: 0,
    maximumFractionDigits: 0,
    currency: "IDR"
  }).format(number);
}

function penyerahan(id)
{
  var data = {pemeriksaan_id: id};

  $.ajax({
    url: controller_url+'/penyerahan',
    type: 'POST',
    data: data,
    success: function(response){    
      $('#modal-view-xl').html(response);
      $('#modal-title').html("<i class='fas fa-hand-holding-heart'></i> | Penyerahan Obat");
    },
    error: function (xhr, ajaxOptions, thrownError) { 
     console.log(xhr.responseText);
   }
 });
}

function panggil(nama)
{ 
  var text = "Pasien atas nama "+nama+" mohon ke penyerahan obat";

 responsiveVoice.speak(
  text,
  "Indonesian Female",
  {
    pitch: 0.9, 
    rate: 0.8, 
    volume: 1
  }
  );
}

function panggil(text)
{
  var data = {
    value: text
  };

  $('.btn').attr('disabled', true);  

  $.ajax({
    url: base_url+'/Pemanggil_obat/add',
    type: 'POST',
    data: data,
    dataType:'json',
    success: function(response){
      notif(response.eror, response.pesan);

      setInterval(function()
      {
        $('.btn').attr('disabled', false); 
        load_tabel(); 
      }, 10000);
    },
    error: function (xhr, ajaxOptions, thrownError) { 
      console.log(xhr.responseText);
    }
  });
}
