<?php
defined('BASEPATH') OR exit('No direct script access allowed'); 

function tersedia($value)
{
  if($value == 'Tidak')
  {
    $result = '<span class="badge bg-warning">'.$value.'</span>';
  }
  else $result = '<span class="badge bg-primary">'.$value.'</span>';

  return $result;
}

?>
<div class="modal-content" style="background-color: #e6f0ff">
  <div class="modal-header" style="background-color: #b3d1ff">
    <table width="100%">
      <tr>
        <td><h5 class="modal-title" id="modal-title"></h5></td>
        <td align="right">
          <button class="btn bg-secondary btn-xs" onclick="panggil('<?php echo strtolower($pasien->nama) ?>')"><i class="fas fa-volume-up"></i> Panggil</button>
        </td>
        <td width="10px" align="right">            
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </td>
      </tr>
    </table>
  </div>    
  <form role="form" method="POST" id="form-data" action="<?php echo $url_form ?>">
    <div class="modal-body">
      <div class="row">
        <div class="col-12 col-sm-4 col-md-4 col-lg-4"> 
          <table width="100%" class="table table-sm table-striped" >
            <tr>
              <th style="width: 100px">Debitur</th>
              <td align="center" width="10px">:</td>
              <td align="left"><b><u><?php echo $pemeriksaan->debitur_value ?></u></b></td>
            </tr>
            <tr>
              <th>No RM</th>
              <td align="center" width="10px">:</td>
              <td align="left"><?php echo $pasien->no_rm ?></td>
            </tr>
            <tr>
              <th>Nama</th>
              <td align="center" width="10px">:</td>
              <td align="left"><?php echo $pasien->nama ?></td>
            </tr>
            <tr>
              <th>Umur</th>
              <td align="center" width="10px">:</td>
              <td align="left"><?php echo $pasien->umur ?></td>
            </tr>
            <tr>
              <th>Jenis kelamin</th>
              <td align="center" width="10px">:</td>
              <td align="left"><?php if($pasien->jenis_kelamin == 'L'){ echo 'Laki-laki'; } else echo 'Perempuan'; ?></td>
            </tr>
            <tr>
              <th>NIK</th>
              <td align="center" width="10px">:</td>
              <td align="left"><?php echo $pasien->nik ?></td>
            </tr>
            <tr>
              <th>Nomor BPJS</th>
              <td align="center" width="10px">:</td>
              <td align="left"><?php echo $pasien->no_bpjs ?></td>
            </tr>
            <tr>
              <th>Alamat</th>
              <td align="center" width="10px">:</td>
              <td align="left"><?php echo $pasien->alamat ?></td>
            </tr>
            <tr>
              <th>Nomor rawat</th>
              <td align="center" width="10px">:</td>
              <td align="left"><strong><?php echo $pemeriksaan->no_rawat ?></strong></td>
            </tr>
            <tr>
              <th>Tanggal Pemeriksaan</th>
              <td align="center" width="10px">:</td>
              <td align="left"><strong><?php echo $pemeriksaan->tgl_pemeriksaan ?></strong></td>
            </tr>
          </table> 
          <div class="form-group">
            <label>Tanggal Penyerahan</label>
            <table width="100%">
              <tr>
                <td width="50%">
                  <div class="input-group input-group-sm">
                    <input type="text" class="form-control form-control-sm" name="penyerahan_obat_date" id="date_penyerahan_obat_date" data-target="#date_penyerahan_obat_date" data-toggle="datetimepicker" value="<?php echo $pemeriksaan->penyerahan_obat_date ?>"  required/>
                    <div class="input-group-append">
                      <span class="input-group-text"><i class="fas fa-calendar-alt"></i></span>
                    </div>
                  </div> 
                </td>
                <td width="50%">
                  <div class="input-group input-group-sm">
                    <input type="text" class="form-control form-control-sm" name="penyerahan_obat_time" id="time_penyerahan_obat_time" data-target="#time_penyerahan_obat_time" data-toggle="datetimepicker" value="<?php echo $pemeriksaan->penyerahan_obat_time ?>"  required/>
                    <div class="input-group-append">
                      <span class="input-group-text"><i class="fas fa-clock"></i></span>
                    </div>
                  </div> 
                </td>
              </tr> 
            </table>                  
          </div> 

          <?php if($pemeriksaan->penyerahan_obat_date != ''){ ?>              

            <div class="card card-primary card-outline card-outline-tabs">
              <div class="card-header p-0 border-bottom-0">
                <ul class="nav nav-tabs" id="custom-tabs-four-tab" role="tablist">
                  <li class="nav-item">
                    <a class="nav-link active" id="tab_2-tab" data-toggle="pill" href="#keterangan_sakit" role="tab" aria-controls="keterangan_sakit" aria-selected="false">Surat Keterangan Sakit</a>
                  </li>
                  <li class="nav-item">
                    <a class="nav-link" id="tab_1-tab" data-toggle="pill" href="#keterangan_sehat" role="tab" aria-controls="keterangan_sehat" aria-selected="true">Surat Keterangan Sehat</a>
                  </li>
                </ul>
              </div>
              <div class="card-body">
                <div class="tab-content" id="custom-tabs-four-tabContent">                  
                  <div class="tab-pane fade show active" id="keterangan_sakit" role="tabpanel" aria-labelledby="tab_2-tab">
                    <table width="100%" class="table table-sm table-striped">
                      <tr>
                        <th> 
                          <div class="form-check">
                            <input class="form-check-input" name="radio_keterangan_sakit" type="radio" id="radio_hari" value="hari" checked>
                            <label class="form-label" for="radio_hari">Hari</label>
                          </div>
                        </th>
                        <td align="center" width="10px">:</td>
                        <td align="left"><input type="number" class="form-control form-control-sm" name="hari_keterangan_sakit" min="1" placeholder="hari" value="1"></td>
                      </tr>
                      <tr>
                        <th>
                          <div class="form-check" style="width: 80px">
                            <input class="form-check-input" name="radio_keterangan_sakit" type="radio" value="tanggal" id="radio_tanggal">
                            <label class="form-label" for="radio_tanggal">Tanggal</label>
                          </div>
                        </th>
                        <td align="center" width="10px">:</td>
                        <td>
                          <div class="form-group">
                            <input type="text" class="form-control form-control-sm" name="tgl_keterangan_sakit" id="tgl_keterangan_sakit">
                          </div>
                        </td>
                      </tr>
                      <tr>
                        <th>Pekerjaan</th>
                        <td align="center" width="10px">:</td>
                        <td align="left"><textarea class="form-control form-control-sm" rows="2" name="pekerjaan_keterangan_sakit"></textarea></td>
                      </tr> 
                      <tr>
                        <th>Diagnosa</th>
                        <td align="center" width="10px">:</td>
                        <td align="left"><input type="checkbox" name="diagnosa"></td>
                      </tr>
                      <tr>
                        <th>Terapi obat</th>
                        <td align="center" width="10px">:</td>
                        <td align="left"><input type="checkbox" name="terapi_obat"></td>
                      </tr>                          
                    </table>  
                    <div class="float-right">
                      <a class="btn btn-sm btn-primary" onclick="print_surat('keterangan_sakit', <?php echo $pemeriksaan->id ?>)"><i class="fas fa-print"></i> Print</a>
                    </div>
                  </div>
                  <div class="tab-pane fade" id="keterangan_sehat" role="tabpanel" aria-labelledby="tab_1-tab">
                    <table width="100%" class="table table-sm table-striped" >
                      <tr>
                        <th>Pekerjaan</th>
                        <td align="center" width="10px">:</td>
                        <td align="left"><textarea class="form-control form-control-sm" rows="2" name="pekerjaan_keterangan_sehat"></textarea></td>
                      </tr>
                      <tr>
                        <th>Keperluan</th>
                        <td align="center" width="10px">:</td>
                        <td align="left"><textarea class="form-control form-control-sm" rows="2" name="keperluan_keterangan_sehat"></textarea></td>
                      </tr> 
                      <tr>
                        <th>Berat Badan</th>
                        <td align="center" width="10px">:</td>
                        <td align="left"><?php echo $pemeriksaan->bpjs_beratBadan ?> kg</td>
                      </tr>
                      <tr>
                        <th>Tinggi Badan</th>
                        <td align="center" width="10px">:</td>
                        <td align="left"><?php echo $pemeriksaan->bpjs_tinggiBadan ?> cm</td>
                      </tr>
                      <tr>
                        <th>Tensi</th>
                        <td align="center" width="10px">:</td>
                        <td align="left"><?php echo $pemeriksaan->bpjs_sistole.' / '.$pemeriksaan->bpjs_diastole ?> mmHg</td>
                      </tr>
                      <tr>
                        <th>Lainnya</th>
                        <td align="center" width="10px">:</td>
                        <td align="left"><textarea class="form-control form-control-sm" rows="2" name="lainnya"></textarea></td>
                      </tr> 
                    </table>
                    <div class="float-right">
                      <a class="btn btn-sm btn-primary" onclick="print_surat('keterangan_sehat', <?php echo $pemeriksaan->id ?>)"><i class="fas fa-print"></i> Print</a>
                    </div>
                  </div>
                </div>
              </div>
            </div>

          <?php } ?>

        </div>      

        <div class="col-12 col-sm-8 col-md-8 col-lg-8"> 
          <div class="card">
            <div class="card-header bg-olive" style="height: 30px; padding: 5px">
              <h5 class="card-title">Data Obat</h5>
            </div>
            <div class="card-body"> 
              <table class="table table-sm table-bordered table-striped table-hover">
                <thead>
                  <tr>
                    <th style="text-align: center;">#</th>
                    <th style="text-align: center;">Jml</th>
                    <th style="text-align: center;">Nama</th>
                    <th style="text-align: center;">Aturan Pakai</th>
                    <th style="text-align: center;">Satuan</th>
                    <th style="text-align: center;">Harga</th>
                    <th style="text-align: center;">Tersedia</th>
                    <th style="text-align: center;">Subtotal</th>
                  </tr>
                </thead>
                <tbody id="check_box">
                  <?php $urut = 0; foreach ($data_obat as $key) { $urut++; ?>
                    <tr>
                      <td style="text-align: center;">
                        <input type="hidden" name="id[]" value="<?php echo $key->id ?>">
                        <input type="checkbox" id="id_<?php echo $key->id ?>" name="checked[]" <?php if($key->tersedia == 'Ya') echo 'checked' ?> value="<?php echo $key->id ?>" onclick="calc_total_tagihan()">
                        <input type="hidden" name="obat_<?php echo $key->id ?>" value="<?php echo $key->nama.' x '.$key->jumlah.' '.$key->satuan_value.' ('.$key->aturan_pakai.')'; ?>">
                      </td>
                      <td style="text-align: center; width: 80px">
                        <input type="number" onchange="calc_total_tagihan()" class="form-control form-control-sm" name="jumlah[]" id="jumlah_<?php echo $key->id ?>" value="<?php echo $key->jumlah ?>" >
                      </td>
                      <td><?php echo $key->nama ?></td>
                      <td style="text-align: center;"><?php echo $key->aturan_pakai ?></td>
                      <td style="text-align: center;"><?php echo $key->satuan_value ?></td>        
                      <td style="text-align: center;">
                        <?php echo 'Rp '. number_format($key->harga, 0, ",", "."); ?>
                        <input type="hidden" id="harga_<?php echo $key->id ?>" name="harga[]" value="<?php echo $key->harga ?>">
                      </td>   
                      <td style="text-align: center;"><?php echo tersedia($key->tersedia) ?></td> 
                      <td style="text-align: center;" id="total_obat_<?php echo $key->id ?>">
                        <?php echo 'Rp '. number_format($key->jumlah*$key->harga, 0, ",", "."); ?>
                      </td>
                      <input type="hidden" id="subtotal_obat_<?php echo $key->id ?>" value="<?php echo $key->jumlah*$key->harga ?>">
                    </tr>
                  <?php } ?>
                  <tr>
                    <td colspan="7" align="right"><b>Total</b></td>
                    <th style="text-align: center;" id="subtotal_obat"><?php echo 'Rp '. number_format($pemeriksaan->subtotal_obat, 0, ",", ".");  ?></th>
                  </tr>
                </tbody>
              </table>
            </div>
          </div>

          <div class="card">
            <div class="card-header bg-olive" style="height: 30px; padding: 5px">
              <h5 class="card-title">Data Tindakan</h5>
            </div>
            <div class="card-body"> 
              <table class="table table-sm table-bordered table-striped table-hover">
                <thead>
                  <tr>
                    <th style="text-align: center;">#</th>
                    <th style="text-align: center;">Nama</th>
                    <th style="text-align: center;">Kategori</th>
                    <th style="text-align: center;">Subtotal</th>
                  </tr>
                </thead>
                <tbody id="check_box">
                  <?php $urut = 0; foreach ($data_tindakan as $key) { $urut++; ?>
                    <tr>
                      <td style="text-align: center;"><?php echo $urut ?></td>
                      <td><?php echo $key->nama ?></td>
                      <td style="text-align: center;"><?php echo $key->kategori_value ?></td>
                      <td style="text-align: center;"><?php echo 'Rp '. number_format($key->total, 0, ",", "."); ?></td>       
                    </tr>
                  <?php } ?>
                  <tr>
                    <td colspan="3" align="right"><b>Total</b></td>
                    <th style="text-align: center;"><b><?php echo 'Rp '. number_format($pemeriksaan->subtotal_tindakan, 0, ",", ".");  ?></b></th>
                  </tr>
                </tbody>
              </table>
            </div>
          </div>

          <div class="card">
            <div class="card-header bg-olive" style="height: 30px; padding: 5px">
              <h5 class="card-title">Jasa Pemeriksaan</h5>
            </div>
            <div class="card-body"> 
              <table class="table table-sm table-bordered table-striped table-hover">
                <thead>
                  <tr>
                    <th style="text-align: center;">#</th>
                    <th style="text-align: center;">Nama</th>
                    <th style="text-align: center;">Subtotal</th>
                  </tr>
                </thead>
                <tbody id="check_box">
                  <tr>
                    <td style="text-align: center;">1</td>
                    <td>Jasa Pemeriksaan Dokter</td>
                    <td style="text-align: center;"><span id="biaya_pemeriksaan"><?php echo 'Rp '. number_format($pemeriksaan->biaya_pemeriksaan, 0, ",", "."); ?></span><a class="float-sm-right" onclick="edit_biaya('biaya_pemeriksaan')"><i class="fas fa-edit"></i></a></td>       
                  </tr>
                  <tr>
                    <td colspan="2" align="right"><b>Total</b></td>
                    <th style="text-align: center;"><b id="subtotal_biaya_pemeriksaan"><?php echo 'Rp '. number_format($pemeriksaan->biaya_pemeriksaan, 0, ",", ".");  ?></b></th>
                  </tr>
                </tbody>
              </table>
            </div>
          </div>

          <div class="card">
            <div class="card-header bg-olive" style="height: 30px; padding: 5px">
              <h5 class="card-title">Pembayaran</h5>
            </div>
            <div class="card-body"> 
              <table class="table table-sm table-bordered table-striped table-hover">
                <thead>
                  <tr>
                    <th style="text-align: center;">Subtotal Obat</th>
                    <th style="text-align: center;">Subtotal Tindakan</th>
                    <th style="text-align: center;">Subtotal Jasa Pemeriksaan</th>
                    <th style="text-align: center;">Total</th>
                  </tr>
                </thead>
                <tbody>
                  <tr>
                    <td style="text-align: center;" id="total_obat"><?php echo 'Rp '. number_format($pemeriksaan->subtotal_obat, 0, ",", "."); ?></td>  
                    <td style="text-align: center;"><?php echo 'Rp '. number_format($pemeriksaan->subtotal_tindakan, 0, ",", "."); ?></td> 
                    <td style="text-align: center;" id="total_biaya_pemeriksaan"><?php echo 'Rp '. number_format($pemeriksaan->biaya_pemeriksaan, 0, ",", "."); ?></td> 
                    <th style="text-align: center;"><span id="total_tagihan"><?php echo 'Rp '.number_format($pemeriksaan->total, 0, ",", "."); ?> </span><a class="float-sm-right" onclick="edit_biaya('total')"><i class="fas fa-edit"></i></a></th>       
                  </tr>
                  <tr>
                    <th style="text-align: right;" colspan="3">Tagihan yang harus dibayarkan oleh pasien : </th>
                    <th style="text-align: center;" id="total_tagihan_pasien"><?php if($pemeriksaan->kategori_debitur_value == 'Cash'){ echo 'Rp '.number_format($pemeriksaan->total, 0, ",", "."); } else echo 'Rp 0'; ?></th>
                  </tr>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="modal-footer">
      <table width="100%">
        <tr>
          <td align="right">
            <input type="hidden" name="kategori_debitur_value" value="<?php echo $pemeriksaan->kategori_debitur_value ?>"> 
            <input type="hidden" name="subtotal_obat" value="<?php echo $pemeriksaan->subtotal_obat ?>">
            <input type="hidden" name="subtotal_tindakan" value="<?php echo $pemeriksaan->subtotal_tindakan ?>">
            <input type="hidden" name="biaya_pemeriksaan" value="<?php echo $pemeriksaan->biaya_pemeriksaan ?>">
            <input type="hidden" name="total" value="<?php echo $pemeriksaan->total ?>">
            <input type="hidden" name="pemeriksaan_id" value="<?php echo $pemeriksaan->id ?>"> 
            <?php if($pemeriksaan->penyerahan_obat_date != ''){ ?>              
              <a class="btn btn-sm btn-primary" onclick="print_surat('keterangan_periksa', <?php echo $pemeriksaan->id ?>)"><i class="fas fa-print"></i> Surat Keterangan Periksa</a> 
              <a class="btn btn-sm btn-primary" onclick="print_surat('copy_resep', <?php echo $pemeriksaan->id ?>)"><i class="fas fa-print"></i> Copy Resep</a> 
              <a class="btn btn-sm btn-primary" onclick="pre_print_nota(<?php echo $pemeriksaan->id ?>)"><i class="fas fa-print"></i> Nota</a>
              <button type="submit" class="btn btn-sm btn-success add_data"><i class="fas fa-save"></i> Update</button>
            <?php } else { ?>
              <button type="submit" class="btn btn-sm btn-primary add_data"><i class="fas fa-save"></i> Sudah diserahkan</button>
            <?php } ?>            
            <button type="button" class="btn btn-default" data-dismiss="modal" class="close"><i class="fas fa-times"></i> Batal</button>
          </td>
        </tr>
      </table>      
    </div>    
  </form>
</div>

<script>
  $(document).ready(function(){    
    $('.select2').select2();
  })

  $('#tgl_keterangan_sakit').daterangepicker({
    locale: {
      format: 'DD/MM/YYYY'
    },
    autoApply: true
  }, function(start, end, label) {
    $('input[name=tgl_keterangan_sakit]').val(start.format('DD/MM/YYYY')+' - '+end.format('DD/MM/YYYY'));
    load_tabel();
  });

  $(document).on('mouseup touchend', function (e) {
    var container = $(".bootstrap-datetimepicker-widget");
    if (!container.is(e.target) && container.has(e.target).length === 0) {
      container.hide();
    }
  });  

  $('#date_penyerahan_obat_date').datetimepicker({    
    focusOnShow: true,
    format: 'Y-MM-DD'
  })

  $('#time_penyerahan_obat_time').datetimepicker({
    format: 'HH:mm'
  })

  function calc_total_tagihan()
  {
    var obat = $("#check_box input:checkbox").map(function(){
      return $(this).val();
    }).get();

    var total_obat = 0;

    obat.forEach(function(value){
      var harga = parseInt($('#harga_'+value).val());
      var jumlah = parseInt($('#jumlah_'+value).val());
      $('#total_obat_'+value).html(rupiah(harga*jumlah)); 
      $('#subtotal_obat_'+value).val(harga*jumlah); 

      if(document.getElementById('id_'+value).checked == true)
      {
        var subtotal_obat = parseInt($('#subtotal_obat_'+value).val());
        total_obat = total_obat+subtotal_obat;
      }    
    });

    $('input[name=subtotal_obat]').val(total_obat);
    $('#subtotal_obat').html(rupiah(total_obat));
    $('#total_obat').html(rupiah(total_obat));

    var subtotal_obat = parseInt($('input[name=subtotal_obat]').val());
    var subtotal_tindakan = parseInt($('input[name=subtotal_tindakan]').val());
    
    var biaya_pemeriksaan = $('input[name=biaya_pemeriksaan]').val();

    var total_tagihan = (subtotal_obat + subtotal_tindakan) + (biaya_pemeriksaan * 1);

    $('input[name=total]').val(total_tagihan);
    $('#total_tagihan').html(rupiah(total_tagihan));

    if($('input[name=kategori_debitur_value]').val() == 'Cash') $('#total_tagihan_pasien').html(rupiah(total_tagihan));
  }

  function print_surat(nama_surat, id)
  {
    var data = {
      nama_surat: nama_surat,
      pemeriksaan_id: id,
      nota: {
        checkbox_detail_obat: $('input[name=checkbox_detail_obat]:checked').val()
      },
      keterangan_sakit: {
        radio: $('input[name=radio_keterangan_sakit]:checked').val(),
        hari: $('input[name=hari_keterangan_sakit]').val(),
        tgl: $('input[name=tgl_keterangan_sakit]').val(),
        pekerjaan: $('textarea[name=pekerjaan_keterangan_sakit]').val(),
        diagnosa: $('input[name=diagnosa]:checked').val(),
        terapi_obat: $('input[name=terapi_obat]:checked').val()
      },
      keterangan_sehat: {
        pekerjaan: $('textarea[name=pekerjaan_keterangan_sehat]').val(),
        keperluan: $('textarea[name=keperluan_keterangan_sehat]').val(),
        lainnya: $('textarea[name=lainnya]').val()
      }
    };
    
    setTimeout(function()
    {
      $.ajax({
        url: controller_url+'/print_surat',
        type: 'POST',
        data: data,
        success: function(response)
        { 
          window.frames["print_frame"].document.title = document.title;
          window.frames["print_frame"].document.body.innerHTML =  response;

          setTimeout(function()
          {
            window.frames["print_frame"].window.focus();
            window.frames["print_frame"].window.print();
          }, 300)        
        },
        error: function (xhr, ajaxOptions, thrownError) { 
         console.log(xhr.responseText);
       }
     });
    }, 1000)
  }

  function pre_print_nota(id)
  {
    Swal.fire({
      title: 'Print Nota',
      html: '<table width="100%"><tr><td align="right" width="45%">Tampilkan detail obat</td><td width="10px"> : </td><td align="left"><input type="checkbox" class="swal2-checkbox" name="checkbox_detail_obat"></td></tr></table>',
      icon: 'warning',
      showCancelButton: true,
      confirmButtonText: 'OK',
      cancelButtonText: 'Batal',
    }).then((result) => {
      if(result.value){
        print_surat('nota', id);
      } 
    })  
  }

  function edit_biaya(id)
  {
    var value = $('input[name='+id+']').val();

    Swal.fire({
      title: 'Edit Biaya',
      html: '<input type="number" class="swal2-input" name="biaya" value="'+value+'">',
      showCancelButton: true,
      confirmButtonText: 'OK',
      cancelButtonText: 'Batal',
    }).then((result) => {
      if(result.value){       
        var biaya = $('input[name=biaya]').val(); 

        if(id == 'total')
        {
          var biaya_pemeriksaan = $('input[name=biaya_pemeriksaan]').val();
          var subtotal_obat = $('input[name=subtotal_obat]').val();
          var subtotal_tindakan = $('input[name=subtotal_tindakan]').val();

          var subtotal = (subtotal_obat * 1) + (subtotal_tindakan * 1);

          biaya = (biaya * 1) - subtotal;
        }      

        $('#biaya_pemeriksaan').html(rupiah(biaya));
        $('#subtotal_biaya_pemeriksaan').html(rupiah(biaya));
        $('#total_biaya_pemeriksaan').html(rupiah(biaya));
        $('input[name=biaya_pemeriksaan]').val(biaya);  
        calc_total_tagihan();
      }
    })  
  }

  $('#form-data').submit(function(e){
    e.preventDefault();
    calc_total_tagihan()
    $('.add_data').attr('disabled', true);  
    $.ajax({
      type: $('#form-data').attr('method'),
      url: base_url+''+$('#form-data').attr('action'),
      data:new FormData(this),
      processData:false,
      contentType:false,
      cache:false,
      async:false,
      dataType:'json',
      success: function(response)
      {
        notif(response.eror, response.pesan);

        if(response.eror == 'success')
        {
          penyerahan($('input[name=pemeriksaan_id]').val());
          load_tabel();
        } 
        else console.log(response);

        $('.add_data').attr('disabled',false);
      },
      error: function (xhr, ajaxOptions, thrownError) {
        console.log(xhr.responseText);
        $('.add_data').attr('disabled',false);
      }  
    });
  })

</script>
