<?php
defined('BASEPATH') OR exit('No direct script access allowed'); 

function convert_tgl($tgl)
{
  return substr($tgl,-2,2).'-'.substr($tgl,5,2).'-'.substr($tgl,0,4);
}

function convert_range_tgl($range)
{
  $split = explode(' - ', $range);

  if(isset($split[0]))
  {
    $tgl['awal'] = substr($split[0],6,4).'-'.substr($split[0],3,2).'-'.substr($split[0],0,2);
  }

  if(isset($split[1]))
  {
    $tgl['akhir'] = substr($split[1],6,4).'-'.substr($split[1],3,2).'-'.substr($split[1],0,2);
  }

  return $tgl;
}

if($post['keterangan_sakit']['radio'] == 'hari')
{
  $tgl_mulai = convert_tgl($pemeriksaan->tgl_pemeriksaan);
  $tgl_akhir = date('d-m-Y', strtotime('+'.$post['keterangan_sakit']['hari'].' day', strtotime($pemeriksaan->tgl_pemeriksaan)));
}
else 
{
  $convert = convert_range_tgl($post['keterangan_sakit']['tgl']);

  $tgl_mulai = convert_tgl($convert['awal']);
  $tgl_akhir = convert_tgl($convert['akhir']);

  $post['keterangan_sakit']['hari'] = ceil((strtotime($convert['akhir']) - strtotime($convert['awal'])) / (60 * 60 * 24))+1;
}

?>

<table width="100%">
  <tr>
    <td rowspan="4">
      <img src="./<?php echo $pengaturan->url_logo_header ?>" height="60">
    </td>
    <th style="font-size:5mm">
      <center>PRAKTEK UMUM <?php echo strtoupper($pengaturan->perusahaan) ?></center>
    </th>
  </tr>
  <tr>
    <td>
      <center><?php echo $pengaturan->alamat ?></center>
    </td>
  </tr>
  <tr>
    <td>
      <center><?php echo $pengaturan->no_telp ?></center>
    </td>
  </tr>
  <?php if($pengaturan->sip != '-' && $pengaturan->sip != '' ){ ?>    
    <tr>
      <td>
        <center>SIP. <?php echo $pengaturan->sip ?></center>
      </td>
    </tr>
  <?php } ?>
</table>
<hr style="border-bottom:2px solid #999999; margin-top:-5px;">
<p style="text-align: center; font-size:5mm">
  <b><u>SURAT KETERANGAN SAKIT</u></b><br>Nomor Rawat. <?php echo $pemeriksaan->no_rawat ?>
</p>
<p>Yang bertanda tangan dibawah ini menerangkan bahwa:</p>

<table width="100%">
  <tr>
    <th style="text-align: left; width: 100px">Nama</th>
    <td style="text-align: center; vertical-align: top; width: 10px;">:</td>
    <td align="left"><?php echo $pasien->nama ?></td>
  </tr>
  <tr>
    <th style="text-align: left;">Umur</th>
    <td style="text-align: center; vertical-align: top; width: 10px">:</td>
    <td align="left"><?php echo $pasien->umur ?></td>
  </tr>
  <tr>
    <th style="text-align: left;">Jenis kelamin</th>
    <td style="text-align: center; vertical-align: top; width: 10px">:</td>
    <td align="left"><?php if($pasien->jenis_kelamin == 'L'){ echo 'Laki-laki'; } else echo 'Perempuan'; ?></td>
  </tr>
  <tr>
    <th style="text-align: left;">Pekerjaan</th>
    <td style="text-align: center; vertical-align: top; width: 10px">:</td>
    <td align="left"><?php echo $post['keterangan_sakit']['pekerjaan'] ?></td>
  </tr>
  <tr>
    <th style="text-align: left;">Alamat</th>
    <td style="text-align: center; vertical-align: top; width: 10px">:</td>
    <td align="left"><?php echo $pasien->alamat ?></td>
  </tr>
</table>
<p>Berdasarkan hasil pemeriksaan yang telah dilakukan dinyatakan sakit dan perlu istirahat selama <?php if($post['keterangan_sakit']['hari'] > 0){ echo $post['keterangan_sakit']['hari']; } else echo 1; ?> hari, mulai dari tanggal <?php echo $tgl_mulai ?> sampai dengan <?php echo $tgl_akhir ?> </p>
<p>Demikian surat keterangan ini dibuat agar digunakan sebagaimana mestinya.</p>
<table width="100%">
  <tr>
    <td style="width: 70%">
      <?php if(isset($post['keterangan_sakit']['diagnosa']) || isset($post['keterangan_sakit']['terapi_obat'])){ ?>
        <p><strong>Keterangan:</strong></p>
        <table width="100%">
          <?php if(isset($post['keterangan_sakit']['diagnosa'])){ ?>
            <tr>
              <th style="text-align: left; width: 100px;">Diagnosa</th>
              <td align="center" width="10px">:</td>
              <td align="left"><?php echo "[$pemeriksaan->bpjs_kdDiag1] $pemeriksaan->bpjs_nmDiag1"; ?></td>
            </tr>
          <?php } if(isset($post['keterangan_sakit']['terapi_obat'])){ ?>
            <tr>
              <th style="text-align: left; width: 100px;">Terapi</th>
              <td align="center" width="10px">:</td>
              <td align="left"><?php foreach ($data_obat as $key){ echo $key->nama.',';  } ?></td>
            </tr>
          <?php } ?>
        </table>
      <?php } ?>
    </td>
    <td style="width: 30%" align="center">
      <table width="100%">
        <tr>
          <td rowspan="3"></td>
          <td style="text-align: center;"><?php echo convert_tgl($pemeriksaan->tgl_pemeriksaan) ?></td>
        </tr>
        <tr>
          <td>
            <br>
            <br>
            <br>
            <br>
          </td>
        </tr>
        <tr>
          <td style="text-align: center;"><?php echo $pemeriksaan->nm_dokter ?></td>
        </tr>
      </table>
    </td>
  </tr>
</table>