<?php
defined('BASEPATH') OR exit('No direct script access allowed');

function tgl_convert($date)
{  
  $bulan = array (
    1 =>   'Januari',
    'Februari',
    'Maret',
    'April',
    'Mei',
    'Juni',
    'Juli',
    'Agustus',
    'September',
    'Oktober',
    'November',
    'Desember'
  );

  if($date != '0000-00-00')
  {
    $split = explode('-', $date); 
    $tgl = $split[2].' '.$bulan[(int)$split[1]].' '.$split[0];
  } 
  else $tgl = '00-00-0000';

  return $tgl;
}

function status($value)
{
  if($value == 'Terkirim')
  {
    $result = '<span class="badge bg-success">'.$value.'</span>';
  }
  else $result = '<span class="badge bg-danger">Belum ['.$value.']</span>';

  return $result;
}

function debitur($value)
{
  if($value == 'BPJS')
  {
    $result = '<span class="badge bg-success">'.$value.'</span>';
  }
  else $result = '<span class="badge bg-primary">'.$value.'</span>';

  return $result;
}

function penyerahan_obat($value)
{
  if($value == 'Belum')
  {
    $result = '<span class="badge bg-warning">'.$value.'</span>';
  }
  else if($value == 'Sudah')
  {
    $result = '<span class="badge bg-success">'.$value.'</span>';
  }
  else $result = '<span class="badge bg-primary">'.$value.'</span>';

  return $result;
}

?>

<div class="table-responsive">
  <table class="table table-sm table-bordered table-striped table-hover">
    <thead>
      <tr>
        <th style="text-align: center; width: 50px">No</th>
        <th style="text-align: center;">Nama</th>
        <th style="text-align: center;">Umur</th>
        <th style="text-align: center;">Urut</th>
        <th style="text-align: center;">Debitur</th>
        <th style="text-align: center;">Tgl. Pemeriksaan</th>
        <th style="text-align: center;">Penyerahan Obat</th>
        <th style="text-align: center; width: 70px">Aksi</th>
      </tr>
    </thead>
    <tbody>
      <?php $urut = $page; foreach ($data as $key){ $urut++; ?>
        <tr>
          <td style="text-align: center;"><?php echo $urut ?></td>  
          <td style="text-align: center;"><span style="font-size: 20px"><?php echo $key->nama ?></span></td> 
          <td style="text-align: center;"><?php echo $key->umur ?></td>         
          <td style="text-align: center;"><?php echo $key->urut ?></td>
          <td style="text-align: center;"><?php echo debitur($key->debitur_value) ?></td>   
          <td style="text-align: center;"><?php echo $key->tgl_pemeriksaan ?></td> 
          <td style="text-align: center;"><?php echo penyerahan_obat($key->penyerahan_obat) ?></td> 
          <td style="text-align: center;">
            <button class="btn btn-info btn-rounded btn-xs" data-toggle="modal" data-target="#modal-data-xl" onclick="penyerahan(<?php echo $key->id ?>)"><i class="fas fa-hand-holding-heart"></i> Pilih</button>
          </td>
        </tr>
      <?php } ?>
    </tbody>
  </table>
</div>

<div class="row">
  <div class="col-12 col-sm-6">
    <p>Jumlah Data: <b><?php echo $jml_data ?></b></p>
  </div>
  <div class="col-12 col-sm-6">
    <?php echo $pagination; ?>
  </div>
</div>

<script type="text/javascript">
  var page_curr = base_url+'<?php echo $page_curr ?>';
  $('.pagination').on('click','a',function(e){
   e.preventDefault(); 
   var url_page = $(this).attr('href');
   url_page = url.protocol+''+url_page.replace('http:', '');
   load_tabel(url_page);
 });
</script>