<?php
defined('BASEPATH') OR exit('No direct script access allowed');
?>

<form role="form" method="POST" id="form-data" action="<?php echo $url_form ?>">
  <div class="modal-content">
    <div class="modal-header">
      <h4 class="modal-title" id="modal-title"></h4>
      <button type="button" class="close" data-dismiss="modal" aria-label="Close">
        <span aria-hidden="true">&times;</span>
      </button>
    </div>
    <div class="modal-body">
      <div class="row">
        <div class="col-12 col-sm-12 col-md-12 col-lg-6">
          <div class="form-group">
            <label>Nama</label>
            <input type="text" class="form-control form-control-sm" name="nama" value="<?php echo $data->nama ?>" disabled>
          </div>
          <div class="form-group">
            <label>Satusehat KFA Code <span class="text-red">*</span></label>
            <input type="text" class="form-control form-control-sm" name="satusehat_kfa_code" placeholder="Enter satusehat kfa code" value="<?php echo $data->satusehat_kfa_code ?>" required>
          </div>
          <div class="form-group">
            <label>Satusehat KFA System <span class="text-red">*</span></label>
            <input type="text" class="form-control form-control-sm" name="satusehat_kfa_system" placeholder="Enter satusehat kfa system" value="<?php echo $data->satusehat_kfa_system ?>" required>
          </div>
          <div class="form-group">
            <label>Satusehat KFA display <span class="text-red">*</span></label>
            <input type="text" class="form-control form-control-sm" name="satusehat_kfa_display" placeholder="Enter satusehat kfa display" value="<?php echo $data->satusehat_kfa_display ?>" required>
          </div>
        </div>        
        <div class="col-12 col-sm-12 col-md-12 col-lg-6">
          <div class="form-group">
            <label>Jenis <span class="text-red">*</span></label>
            <select class="form-control form-control-sm" name="jenis" onchange="change_jenis(this.value)" required> 
              <option value="" selected hidden disabled></option>
              <?php foreach ($select_jenis as $key){ ?>                
                <option value="<?php echo $key->id ?>" <?php if($data->jenis == $key->id){ echo 'selected'; } ?>><?php echo $key->value ?></option>
              <?php } ?>                     
            </select>     
          </div> 
          <div class="form-group">
            <label>Satusehat Form Code</label>
            <input type="text" class="form-control form-control-sm" name="satusehat_form_code" placeholder="Enter satusehat form code" value="<?php echo $data->satusehat_form_code ?>" disabled>
          </div>
          <div class="form-group">
            <label>Satusehat Form System</label>
            <input type="text" class="form-control form-control-sm" name="satusehat_form_system" placeholder="Enter satusehat form system" value="<?php echo $data->satusehat_form_system ?>" disabled>
          </div>
          <div class="form-group">
            <label>Satusehat Form display</label>
            <input type="text" class="form-control form-control-sm" name="satusehat_form_display" placeholder="Enter satusehat form display" value="<?php echo $data->satusehat_form_display ?>" disabled>
          </div>
        </div>
      </div>
      <p class="text-red"> * Wajib diisi</p>  
    </div>
    <div class="modal-footer">
      <input type="hidden" name="satusehat_id" value="<?php echo $data->satusehat_id ?>">
      <input type="hidden" name="id" value="<?php echo $data->id ?>">
      <button type="submit" class="btn btn-primary add_data"><i class="fas fa-save"></i> Simpan</button>
      <button type="button" class="btn btn-default" data-dismiss="modal" class="close"><i class="fas fa-times"></i> Batal</button>
    </div>
  </div>
</form>

<script>
  $(document).ready(function(){    
    $('.select2').select2();
  })

  function change_checked(value)
  {
    $('input[name=id]').attr('disabled', value);
    $('input[name=id]').attr('readonly', value);

    if(value == true)
    {
     $('input[name=id]').val('Auto'); 
   } 
   else $('input[name=id]').val('');
 }

 function change_jenis(value)
 {
  var data = {id: value};

  $.ajax({
    url: base_url+'/asset_jenis_obat/lihat',
    type: 'POST',
    data: data,
    dataType:'json',
    success: function(response){  
      $('input[name=satusehat_form_code]').val(response.satusehat_form_code);
      $('input[name=satusehat_form_system]').val(response.satusehat_form_system);
      $('input[name=satusehat_form_display]').val(response.satusehat_form_display);
    },
    error: function (xhr, ajaxOptions, thrownError) { 
      console.log(xhr.responseText);
    }
  });
}

$('#form-data').submit(function(e){
  e.preventDefault();
  $('.add_data').attr('disabled', true);  
  $.ajax({
    type: $('#form-data').attr('method'),
    url: base_url+''+$('#form-data').attr('action'),
    data:new FormData(this),
    processData:false,
    contentType:false,
    cache:false,
    async:false,
    dataType:'json',
    success: function(response){
      notif(response.eror,response.pesan);
      if(response.eror == "success"){
        load_tabel(page_curr);
        $('.modal').modal('hide');
      } else $('.add_data').attr('disabled',false);
    },
    error: function (xhr, ajaxOptions, thrownError) {
      console.log(xhr.responseText);
      $('.add_data').attr('disabled',false);
    }  
  });
})

</script>
