<?php
defined('BASEPATH') OR exit('No direct script access allowed');

function tgl_convert($date)
{  
  $bulan = array (
    1 =>   'Januari',
    'Februari',
    'Maret',
    'April',
    'Mei',
    'Juni',
    'Juli',
    'Agustus',
    'September',
    'Oktober',
    'November',
    'Desember'
  );

  if($date != '0000-00-00')
  {
    $split = explode('-', $date); 
    $tgl = $split[2].' '.$bulan[(int)$split[1]].' '.$split[0];
  } 
  else $tgl = '00-00-0000';

  return $tgl;
}

function status($value)
{
  if($value == 'Terkirim')
  {
    $result = '<i class="fas fa-clipboard-check" style="color: green"></i>';
  }
  else $result = '<i class="fas fa-calendar-times"></i>';

  return $result;
}

?>

<div class="table-responsive">
  <table class="table table-sm table-bordered table-striped table-hover">
    <thead>
      <tr>
        <th style="text-align: center; width: 50px">No</th>
        <th style="text-align: center;">Nama</th>
        <th style="text-align: center;">Tanggal Daftar</th>
        <th style="text-align: center;">Sistole</th>
        <th style="text-align: center;">Diastole</th>
        <th style="text-align: center;">Heart Rate</th>
        <th style="text-align: center;">Lingkar Perut</th>
        <th style="text-align: center;">Berat Badan</th>
        <th style="text-align: center;">Tinggi Badan</th>
        <th style="text-align: center;">Respirasi Rate</th>
        <th style="text-align: center;">Kesadaran</th>
        <th style="text-align: center;">Suhu</th>
        <th style="text-align: center; width: 90px">Aksi</th>
      </tr>
    </thead>
    <tbody>
      <?php $urut = $page; foreach ($data as $key){ $urut++; ?>
        <tr>
          <td style="text-align: center;"><?php echo $urut ?></td> 
          <td><?php echo $key->nama ?><br>(<?php echo $key->no_rawat ?>)</td>
          <td style="text-align: center;"><?php echo $key->tgl_daftar ?></td>  
          <td><?php echo status($key->sistole_satusehat).' '.$key->sistole ?></td>
          <td><?php echo status($key->diastole_satusehat).' '.$key->diastole ?></td>
          <td><?php echo status($key->heart_rate_satusehat).' '.$key->heart_rate ?></td>
          <td><?php echo status($key->lingkar_perut_satusehat).' '.$key->lingkar_perut ?></td>
          <td><?php echo status($key->berat_badan_satusehat).' '.$key->berat_badan ?></td>
          <td><?php echo status($key->tinggi_badan_satusehat).' '.$key->tinggi_badan ?></td>
          <td><?php echo status($key->respirasi_rate_satusehat).' '.$key->respirasi_rate ?></td>
          <td><?php echo status($key->kesadaran_satusehat).' '.$key->kesadaran ?></td>
          <td><?php echo status($key->suhu_satusehat).' '.$key->suhu ?></td>
          <td style="text-align: center;">
            <?php if($key->observation_satusehat_id != ''){ ?>
              <button class="btn btn-info btn-rounded btn-xs" onclick="kirim('<?php echo $key->no_rawat ?>')"><i class="fas fa-sync-alt"></i> Update</button>
            <?php } else { ?>
              <button class="btn btn-warning btn-rounded btn-xs" onclick="kirim('<?php echo $key->no_rawat ?>')"><i class="fas fa-upload"></i> Kirim</button>
            <?php } ?>
          </td>
        </tr> 
      <?php } ?>
    </tbody>
  </table>
</div>

<div class="row">
  <div class="col-12 col-sm-6">
    <p>Jumlah Data: <b><?php echo $jml_data ?></b></p>
  </div>
  <div class="col-12 col-sm-6">
    <?php echo $pagination; ?>
  </div>
</div>

<script type="text/javascript">
  var page_curr = base_url+'<?php echo $page_curr ?>';
  $('.pagination').on('click','a',function(e){
   e.preventDefault(); 
   var url_page = $(this).attr('href');
   url_page = url.protocol+''+url_page.replace('http:', '');
   load_tabel(url_page);
 });
</script>